unit PluginF;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  IBEIntfEx, StdCtrls;

type
  TDBInfoForm = class(TForm)
    cbDatabases: TComboBox;
    Label1: TLabel;
    Memo: TMemo;
    Label2: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure cbDatabasesChange(Sender: TObject);
  private
    procedure Init;
  public
    Intf: TIBEInterfaceEx;
  end;

var
  OldHandle: THandle;

procedure ShowDatabaseInfo(Intf : TIBEInterfaceEx);

implementation

procedure ShowDatabaseInfo(Intf : TIBEInterfaceEx);
var
  Frm : TDBInfoForm;
begin
  OldHandle := Application.Handle;
  Application.Handle := TApplication(Intf.MainApplication).Handle;
  Frm := TDBInfoForm.Create(TApplication(Intf.MainApplication));
  Frm.Intf := Intf;
  Frm.Init;
  Frm.Show;
end;

{$R *.DFM}

procedure TDBInfoForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
 // Application.Handle := OldHandle;
end;

procedure TDBInfoForm.Init;
var
  iCount, i : integer;
  DB : hDB;
  DBInfo : PibeiDatabaseInfo;
begin
  iCount := Intf.DBCount;
  for i := 0 to pred(iCount) do
  begin
    DB := Intf.GetDBByIndex(i);
    DBInfo := Intf.GetDBInfo(DB);
    try
      cbDatabases.Items.AddObject(DBInfo.Alias,TObject(DB));
    finally
      Intf.FreeDBInfo(DBInfo);
    end;
  end;
  if cbDatabases.Items.Count > 0 then
  begin
    cbDatabases.ItemIndex := 0;
    cbDatabasesChange(nil);
  end;
end;

procedure TDBInfoForm.cbDatabasesChange(Sender: TObject);
var
  DBInfo : PibeiDatabaseInfo;
  DB : hDB;
begin
  Memo.Lines.Clear;
  DB := cbDatabases.Items.Objects[cbDatabases.ItemIndex];
  if Assigned(DB) then
  begin
    DBInfo := Intf.GetDBInfo(DB);
    try
      Memo.Lines.Add('Alias: ' + DBInfo.Alias);
      Memo.Lines.Add('File: ' + DBInfo.FileName);
      Memo.Lines.Add('Server: ' + DBInfo.ServerName);
      Memo.Lines.Add('Protocol: ' + DBInfo.ProtocolAsString);
      Memo.Lines.Add('User: ' + DBInfo.UserName);
      Memo.Lines.Add('Password: ' + DBInfo.Password);
      Memo.Lines.Add('Role: ' + DBInfo.Role);
      Memo.Lines.Add('Connection Charset: ' + DBInfo.ConnectionCharset);
    finally
      Intf.FreeDBInfo(DBInfo);
    end;
  end;
end;

end.
